/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.entities;

import com.ordana.spelunkery.reg.ModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PrimedMineomiteEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(PrimedMineomiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int DEFAULT_FUSE_TIME = 80;
    @Nullable
    private LivingEntity owner;
    private int sticks;

    public PrimedMineomiteEntity(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
        this.f_19850_ = true;
    }

    public PrimedMineomiteEntity(Level level, int i, double d, double e, double f, @Nullable LivingEntity livingEntity) {
        this(ModEntities.PRIMED_MINEOMITE.get(), level);
        this.sticks = i;
        this.m_6034_(d, e, f);
        double g = level.f_46441_.m_188500_() * 6.2831854820251465;
        this.m_20334_(-Math.sin(g) * 0.02, 0.2f, -Math.cos(g) * 0.02);
        this.setFuse(80);
        this.f_19854_ = d;
        this.f_19855_ = e;
        this.f_19856_ = f;
        this.owner = livingEntity;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)80);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        int i = this.getFuse() - 1;
        this.setFuse(i);
        if (i <= 0) {
            this.m_146870_();
            if (!this.f_19853_.f_46443_) {
                this.explode();
            }
        } else if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    private void explode() {
        float f = this.sticks * 2;
        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), f, Explosion.BlockInteraction.BREAK);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128376_("Fuse", (short)this.getFuse());
    }

    protected void m_7378_(CompoundTag compound) {
        this.setFuse(compound.m_128448_("Fuse"));
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return 0.15f;
    }

    public void setFuse(int life) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)life);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

